/*
 * Decompiled with CFR 0.152.
 */
package com.pfg.mi1robot;

import com.pfg.mi1robot.Bitmap;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Set;

public class Escenario {
    private Bitmap escenario;

    public Escenario(Bitmap escenario) {
        this.escenario = escenario;
    }

    public void setEscenario(Bitmap escenario) {
        this.escenario = escenario;
    }

    public Bitmap getEscenario() {
        return this.escenario;
    }

    public void draw(Graphics g) {
        g.drawImage(this.escenario.getImagenBufeada(), 0, 0, 600, 360, null);
    }

    public Color getColor(int x, int y) {
        int pixel = this.escenario.getImagenBufeada().getRGB(x, y);
        int red = (pixel & 0xFF0000) >> 16;
        int green = (pixel & 0xFF00) >> 8;
        int blue = pixel & 0xFF;
        HashMap<String, String> colores = new HashMap<String, String>();
        colores.put("White", "255_255_255");
        colores.put("Amarillo", "255_255_0");
        colores.put("Magenta", "255_0_255");
        colores.put("Cian", "0_255_255");
        colores.put("Red", "255_0_0");
        colores.put("Purple", "128_0_128");
        colores.put("Pink", "255_192_203");
        colores.put("Orange", "255_165_0");
        colores.put("Green", "0_255_0");
        colores.put("Grey", "128_128_128");
        colores.put("Brown", "97_33_11");
        colores.put("Blue", "0_0_255");
        colores.put("Black", "0_0_0");
        double maximo = 2000000.0;
        String stringmaximo = "none";
        double xwhite = 95.05;
        double ywhite = 100.0;
        double zwhite = 108.9;
        double var_R = (float)red / 255.0f;
        double var_G = (float)green / 255.0f;
        double var_B = (float)blue / 255.0f;
        var_R = var_R > 0.04045 ? Math.pow((var_R + 0.055) / 1.055, 2.4) : (var_R /= 12.92);
        var_G = var_G > 0.04045 ? Math.pow((var_G + 0.055) / 1.055, 2.4) : (var_G /= 12.92);
        var_B = var_B > 0.04045 ? Math.pow((var_B + 0.055) / 1.055, 2.4) : (var_B /= 12.92);
        double xori = (var_R *= 100.0) * 0.4124 + (var_G *= 100.0) * 0.3576 + (var_B *= 100.0) * 0.1805;
        double yori = var_R * 0.2126 + var_G * 0.7152 + var_B * 0.0722;
        double zori = var_R * 0.0193 + var_G * 0.1192 + var_B * 0.9505;
        double var_X = xori / xwhite;
        double var_Y = yori / ywhite;
        double var_Z = zori / zwhite;
        var_X = var_X > 0.008856 ? Math.pow(var_X, 0.3333333432674408) : 7.787 * var_X + 0.0;
        var_Y = var_Y > 0.008856 ? Math.pow(var_Y, 0.3333333432674408) : 7.787 * var_Y + 0.0;
        var_Z = var_Z > 0.008856 ? Math.pow(var_Z, 0.3333333432674408) : 7.787 * var_Z + 0.0;
        double CIELori = 116.0 * var_Y - 16.0;
        double CIEaori = 500.0 * (var_X - var_Y);
        double CIEbori = 200.0 * (var_Y - var_Z);
        Set valores = colores.keySet();
        for (String valor : valores) {
            String cadena = (String)colores.get(valor);
            String[] partido = cadena.split("_");
            var_R = (float)Integer.parseInt(partido[0]) / 255.0f;
            var_G = (float)Integer.parseInt(partido[1]) / 255.0f;
            var_B = (float)Integer.parseInt(partido[2]) / 255.0f;
            var_R = var_R > 0.04045 ? Math.pow((var_R + 0.055) / 1.055, 2.4) : (var_R /= 12.92);
            var_G = var_G > 0.04045 ? Math.pow((var_G + 0.055) / 1.055, 2.4) : (var_G /= 12.92);
            var_B = var_B > 0.04045 ? Math.pow((var_B + 0.055) / 1.055, 2.4) : (var_B /= 12.92);
            xori = (var_R *= 100.0) * 0.4124 + (var_G *= 100.0) * 0.3576 + (var_B *= 100.0) * 0.1805;
            yori = var_R * 0.2126 + var_G * 0.7152 + var_B * 0.0722;
            zori = var_R * 0.0193 + var_G * 0.1192 + var_B * 0.9505;
            var_X = xori / xwhite;
            var_Y = yori / ywhite;
            var_Z = zori / zwhite;
            var_X = var_X > 0.008856 ? Math.pow(var_X, 0.3333333333333333) : 7.787 * var_X + 0.0;
            var_Y = var_Y > 0.008856 ? Math.pow(var_Y, 0.3333333333333333) : 7.787 * var_Y + 0.0;
            var_Z = var_Z > 0.008856 ? Math.pow(var_Z, 0.3333333333333333) : 7.787 * var_Z + 0.0;
            double CIELm = 116.0 * var_Y - 16.0;
            double CIEam = 500.0 * (var_X - var_Y);
            double CIEbm = 200.0 * (var_Y - var_Z);
            double diferencia = this.distanceRGB(CIELm, CIEam, CIEbm, CIELori, CIEaori, CIEbori);
            if (!(diferencia < maximo)) continue;
            maximo = diferencia;
            stringmaximo = valor;
        }
        String cadena = (String)colores.get(stringmaximo);
        String[] partido = cadena.split("_");
        red = Integer.parseInt(partido[0]);
        green = Integer.parseInt(partido[1]);
        blue = Integer.parseInt(partido[2]);
        Color c = new Color(red, green, blue);
        return c;
    }

    private double distanceRGB(double CIELm, double CIEam, double CIEbm, double CIELori, double CIEaori, double CIEbori) {
        double lcuadrado = Math.pow(CIELm - CIELori, 2.0);
        double acuadrado = Math.pow(CIEam - CIEaori, 2.0);
        double bcuadrado = Math.pow(CIEbm - CIEbori, 2.0);
        return Math.pow(lcuadrado + acuadrado + bcuadrado, 0.5);
    }

    public void setColor(int x, int y, int pixel) {
        int xaux = x - 10;
        int initx = xaux + 20;
        if (xaux < 0) {
            x = 0;
        }
        while (xaux <= initx && xaux < this.escenario.getWidth()) {
            int yaux = y - 10;
            int inity = yaux + 20;
            if (yaux < 0) {
                y = 0;
            }
            while (yaux <= inity && yaux < this.escenario.getHeight()) {
                this.escenario.getImagenBufeada().setRGB(xaux, yaux, pixel);
                ++yaux;
            }
            ++xaux;
        }
    }
}

